<?php

namespace Modules\Payment\Entities;

use App\User;
use Illuminate\Database\Eloquent\Model;
use Modules\LaboratoryOrder\Entities\LaboratoryOrder;
use Modules\Order\Entities\Order;

class Payment extends Model
{
    const STATUS_UNPAID = false;
    const STATUS_PAID   = true;

    protected $fillable = [
        'order_id',
        'laboratory_order_id',
        'user_id',
        'amount',
        'tracking_code',
        'transaction_id',
        'ref_id',
        'pay_gate',
        'status',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function laboratory_order()
    {
        return $this->belongsTo(LaboratoryOrder::class);
    }

}
