<?php

namespace Modules\Payment\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Modules\Payment\Entities\Payment;
use Modules\Setting\Entities\Setting;
use Shetabit\Multipay\Exceptions\InvalidPaymentException;
use Shetabit\Multipay\Invoice;
use App\Models\Buyer;

class PaymentController extends Controller
{
    public function request(Request $request)
    {
        $api_key     = $request->api_key;
        $settings    = Setting::where(['autoload' => 1])->pluck('value', 'key')->all();
        $api_key_org = $settings['api_key'];
        // $amount      = 1000;
        // $callback    = 'https://mahdinourbakhsh.ir';
        
        $amount      = $request->amount;
        $callback    = $request->callback;
        abort_unless($api_key == $api_key_org, 403, 'شما اجازه انجام این عملیات را ندارید.');
        $description = $settings['form_description'];
        session(['amount'   => $amount]);
        session(['callback' => $callback]);

        return view('frontend.form', compact('description'));
    }
    
    public function goToPayGate(Request $request)
    {
        $settings = Setting::where(['autoload' => 1])->pluck('value', 'key')->all();
        $merchant = $settings['zarinpal_merchant'];
        
        $order_id      = $request->order_id;
        $mobile        = $request->mobile;
        $national_code = $request->national_code;
        $code          = $request->code;

        $invoice = new Invoice();
        $invoice->amount(session()->get('amount'))->via('zarinpal');
        $invoice->detail([
            'mobile' => $mobile,
        ]);
        return \Shetabit\Payment\Facade\Payment::callbackUrl(route('pay.callback'))->purchase(
            $invoice,
            function($driver, $transactionId) use($mobile, $national_code, $code) {
                Buyer::where([
                    ['mobile', $mobile],
                    ['national_code', $national_code],
                    ['verification_code', $code]
                ])->update(['pay_gate' => 'zarinpal', 'transaction_id' => $transactionId]);
            }
        )->pay()->render();

    }

    public function callback(Request $request)
    {
        $transaction_id = $request->Authority;
        $buyer          = Buyer::where('transaction_id', $transaction_id)->first();
        
        try {
            $receipt = \Shetabit\Payment\Facade\Payment::amount($payment->amount)
                ->transactionId($transaction_id)->verify();

            Buyer::where('transaction_id', $transaction_id)->update([
                'status' => 1,
                'ref_id' => $receipt->getReferenceId(),
            ]);

            $callback = session()->get('callback').'st=100';
            return redirect($callback);
        }
        catch (InvalidPaymentException $exception) {
            $callback = session()->get('callback').'st=-1';
            return redirect($callback);
        }
    }

}
