<?php


namespace Modules\Payment\Http\Middleware;

use Closure;

class CheckProductPaymentType
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $payment_type = session()->get('payment_type');
        if ($payment_type=='check') {
            if(session()->has('check_id')) {
                return redirect()->route('orders.store');
            }
            else {
                return redirect()->route('payments.check.form');
            }
        }
        else{
            return $next($request);
        }

    }
}