<?php

namespace Modules\Setting\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class SettingsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        DB::table('settings')->truncate();

        $settings = [
            [
                'key'       => 'title',
                'label'     => 'عنوان سایت',
                'autoload'  => 1,
            ],
            [
                'key'       => 'meta_keywords',
                'label'     => 'کلمات کلیدی',
                'autoload'  => 1,
            ],
            [
                'key'       => 'description',
                'label'     => 'متای توضیحات',
                'autoload'  => 1,
            ],
            [
                'key'       => 'app_bazaar',
                'label'     => 'لینک اپلیکیشن کافه بازار',
                'autoload'  => 1,
            ],
            [
                'key'       => 'app_store',
                'label'     => 'لینک اپلیکیشن اپ استور',
                'autoload'  => 1,
            ],
            [
                'key'       => 'address',
                'label'     => 'آدرس فروشگاه',
                'autoload'  => 1,
            ],
            [
                'key'       => 'tel',
                'label'     => 'تلفن',
                'autoload'  => 1,
            ],
            [
                'key'       => 'email',
                'label'     => 'ایمیل',
                'autoload'  => 1,
            ],
            [
                'key'       => 'fax',
                'label'     => 'فکس',
                'autoload'  => 1,
            ],
            [
                'key'       => 'twitter',
                'label'     => 'توئیتر',
                'autoload'  => 1,
            ],
            [
                'key'       => 'instagram',
                'label'     => 'اینستاگرام',
                'autoload'  => 1,
            ],
            [
                'key'       => 'telegram',
                'label'     => 'تلگرام',
                'autoload'  => 1,
            ],
            [
                'key'       => 'facebook',
                'label'     => 'فیسبوک',
                'autoload'  => 1,
            ],
            [
                'key'       => 'copyright',
                'label'     => 'متن کپی رایت فوتر',
                'autoload'  => 1,
            ],
        ];

        DB::table('settings')->insert($settings);

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        Model::reguard();
    }
}
