<?php

namespace Modules\User\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUser extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name'    => 'nullable',
            'last_name'     => 'nullable',
            'role'          => 'required|exists:roles,id',
            'password'      => 'required',
            'email'         => 'nullable|unique:users',
            'mobile'        => 'required|unique:users',
            'city'          => 'nullable|exists:cities,id',
            'phone'         => 'nullable|size:11',
            'post_code'     => 'nullable|size:10',
            'address'       => 'nullable',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
