<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => ['auth', 'twoFactor', 'verified']], function() {
    Route::get('/blocked_users', 'AdminController@indexBlockedUsers')->name('blocked_users.index');
    Route::get('/blocked_users/create', 'AdminController@createBlockedUsers')->name('blocked_users.create');
    Route::post('/blocked_users', 'AdminController@storeBlockedUsers')->name('blocked_users.store');
    Route::delete('/blocked_users', 'AdminController@destroyBlockedUsers')->name('blocked_users.destroy');

    Route::resource('/users', 'AdminController');
});
