<?php

use Melipayamak\MelipayamakApi;
use Modules\Setting\Entities\Setting;

if (!(function_exists('user_has'))) {
    /**
     * Determine if the current user has any of the specific permissions.
     *
     * @param $permissions array permission needed to be check
     * @param $userPermissions array permissions of a specific user
     * @return bool
     */
    function user_has($permissions, $userPermissions)
    {
        return !empty(array_intersect($permissions, $userPermissions));
    }
}

if(!function_exists('callout')) {
    /**
     * Prepares flash data to use in panel.layout.partials.blade template.
     *
     * This function helps you to create appropriate Callout boxes. Every call create one callout.
     * you can hide icon by passing null values to the third argument of this function.
     *
     * @param string $message Sets a message for the callout
     * @param string|null $title Sets a title for the callout. pass null to remove it
     * @param string|null $type Sets a title for the callout. pass null to remove ir or pass on of the following values: info, warning, danger, success
     * @param string $button Sets it true to show a button
     */
    function callout($message, $title = 'توجه', $type = 'info', $button = false) {

        if ($title !== null)
        {
            $title .= ': ';
        }

        switch ($type)
        {
            case 'success':
                $icon = 'check';
                break;
            case 'warning':
                $icon = 'exclamination-triangle';
                break;
            case 'danger':
                $icon = 'close';
                break;
            case null:
                $icon = null;
                break;
            case 'info':
            default:
                $icon = 'info';
        }

        if (!in_array($type, ['info', 'danger', 'warning', 'success'])) {
            $type = 'info';
        }

        if (session()->has('callout'))
        {
            $callouts = session()->get('callout');
        }

        if ($button !== true)
        {
            $button = false;
        }

        $callouts[] = [
            'message'   => $message,
            'title'     => $title,
            'type'      => $type,
            'icon'      => $icon,
            'button'    => $button,
        ];

        session()->flash('callout', $callouts);
    }
}

if (!function_exists('dash2comma')) {
    /**
     * Converts hyphen (-) to comma (,) with removing whitespaces.
     *
     * @param $string string The string you want to convert
     * @return bool|string FALSE if not string and converted string if string
     */
    function dash2comma($string) {
        if (!is_string($string) OR is_null($string)) {
            return NULL;
        }
        $array = explode('-', $string);
        $array = array_map('trim', $array);
        return implode(',', $array);
    }
}

if (!function_exists('comma2dash')) {
    /**
     * Converts comma (,) to hyphen (-) with removing whitespaces.
     *
     * @param $string string The string you want to convert
     * @return bool|string FALSE if not string and converted string if string
     */
    function comma2dash($string) {
        if (!is_string($string)OR is_null($string)) {
            return NULL;
        }
        $array = explode(',', $string);
        $array = array_map('trim', $array);
        return implode('-', $array);
    }
}

if(!function_exists('encrypt_pkcs7')) {
    /**
     * Create sign data(Tripledes(ECB,PKCS7)).
     *
     * @param $str
     * @param $key
     * @return string
     */
    function encrypt_pkcs7($str, $key)
    {
        $key = base64_decode($key);
        $ciphertext = OpenSSL_encrypt($str,"DES-EDE3", $key, OPENSSL_RAW_DATA);
        return base64_encode($ciphertext);
    }
}

if(!function_exists('SendSMS')) {
    function SendSMS($to, $text, $text_id=null)
    {
        $settings    = Setting::where(['autoload' => 1])->pluck('value', 'key')->all();
        $username    = $settings['meli_payamak_username'];
        $password    = $settings['meli_payamak_password'];
        $line_number = $settings['meli_payamak_from'];
        try {
            $api      = New MelipayamakApi($username, $password);
            $sms      = $api->sms('soap');
            $from     = $line_number;
            if (is_null($text_id)) {
                $response = $sms->send($to, $from, $text);
            }
            else {
                $response = $sms->sendByBaseNumber($text, $to, $text_id);
            }
            $json     = json_decode($response);
            return $json->Value; //RecId or Error Number
        }
        catch (Exception $e) {
            return $e->getMessage();
        }
    }
}

if(!function_exists('to_persian_numbers')) {
    /**
     * convert latin number to persian
     *
     * @param string $string
     *   string that we want change number format
     *
     * @return formated string
     */
    function to_persian_numbers($string) {
        return str_replace(range(0, 9), ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'], $string);
    }
}

if (!function_exists('to_latin_numbers')) {
    /**
     * convert persian number to latin
     *
     * @param string $string
     *   string that we want change number format
     *
     * @return formated string
     */
    function to_latin_numbers($string) {
        return str_replace(['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'], range(0, 9), $string);
    }
}

if (! function_exists('words')) {
    /**
     * Limit the number of words in a string.
     *
     * @param  string  $value
     * @param  int     $words
     * @param  string  $end
     * @return string
     */
    function words($value, $words = 100, $end = '...')
    {
        return \Illuminate\Support\Str::words(strip_tags($value), $words,$end);
    }
}
if (! function_exists('getJibitToken')) {
    function getJibitToken()
    {
        $curl = curl_init();
        $data = [
            'apiKey'    => env('JIBIT_API_KEY'),
            'secretKey' => env('JIBIT_API_SECRET')
        ];
        curl_setopt_array($curl, array(
            CURLOPT_URL            => env('JIBIT_BASE_URL').'/v1/tokens/generate',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING       => '',
            CURLOPT_MAXREDIRS      => 10,
            CURLOPT_TIMEOUT        => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST  => 'POST',
            CURLOPT_POSTFIELDS     => json_encode($data),
            CURLOPT_HTTPHEADER     => array(
                'Content-Type: application/json',
            ),
        ));

        $response = json_decode(curl_exec($curl));

        curl_close($curl);
        if (property_exists($response, 'accessToken')) {
            $token = $response->accessToken;
        }
        else {
            $token = false;
        }

        return $token;
    }
}
