<?php

namespace App\Http\Controllers\Admin;

use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionController extends Controller
{
    /**
     * RolesController constructor.
     */
    public function __construct()
    {
        $this->middleware('permission:manage-roles');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $role = Role::with('permissions')->find($id);
        $permissions        = Permission::all();
        $userPermissions    = $role->permissions->pluck('id')->toArray() ?? [];

        return view('admin.permissions.edit', compact('role', 'permissions', 'userPermissions'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param   int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $role = Role::findOrFail($id);
        $role->permissions()->sync($request->permissions_id ?? []);

        $users = User::whereHas('roles', function($q) use($id) {
            $q->where('id', $id);
        })->get();
        foreach ($users as $user) {
            DB::table('model_has_permissions')->where('model_id', $user->id)->delete();
            foreach ($request->permissions_id as $permission_id) {
                DB::table('model_has_permissions')->insert([
                    'permission_id' => $permission_id,
                    'model_type'    => 'App\User',
                    'model_id'      => $user->id
                ]);
            }
        }

        $this->doneMessage('دسترسی‌های گروه کاربری با موفقیت ویرایش شدند.');

        return redirect()->route('admin.roles.index');
    }
}
