<?php

namespace App\Listeners;

use App\Library\FarazSMS;
use App\Models\TwoFactor;
use Illuminate\Http\Request;
use Melipayamak\MelipayamakApi;

class SendMobileVerificationCode
{
    /**
     * Create the event listener.
     *
     * @param \Illuminate\Http\Request $request
     * @return void
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle($event)
    {
        $user = $event->user;

        $twoFactor = new TwoFactor([
            'code'    => TwoFactor::generateCode(),
            'user_id' => $user->id,
        ]);
        $twoFactor->save();

        $user->two_factor_verified_at = null;
        $user->save();
        $mobile = $user->mobile;

        //SMS TO USER
        SendSMS($mobile, $twoFactor->code, '167401');
    }
}
