<?php

namespace App;

class MenuFactory {

    /**
     * Builds hierarchy menu.
     *
     * @return array $menu menu
     */
    public static function build(){
        $menus = [
            [
                'label'       => 'داشبورد',
                'permissions' => ['admin-dashboard'],
                'icon'        => 'fas fa-desktop fa-fw',
                'route_name'  => 'admin.site.index',
            ],
            [
                'route_name'  => 'admin.users.index',
                'label'       => 'ادمین ها',
                'icon'        => 'fa fa-users',
                'permissions' => ['manage-users'],
            ],
            [
                'route_name'    => 'admin.blocked_users.index',
                'label'         => 'کاربران بلاک شده',
                'icon'          => 'fa fa-user-secret',
                'permissions'   => ['manage-users'],
            ],
            [
                'route_name'  => 'admin.settings.index',
                'label'       => 'تنظیمات',
                'icon'        => 'fas fa-cogs fa-fw',
                'permissions' => ['manage-settings'],
            ],
        ];

        $currentRouteName = app('router')->getCurrentRoute()->getName();

        foreach($menus as &$menu) {
            if(isset($menu['route_name']) && $currentRouteName == $menu['route_name']) {
                $menu['active'] = true;
            }

            if(isset($menu['children']) && $menu['children']) {
                foreach($menu['children'] as &$child) {
                    if(isset($child['route_name']) && $currentRouteName == $child['route_name']) {
                        $menu['active'] = true;
                        $child['active'] = true;
                    }

                    if(isset($menu['permissions']) && $child['permissions']) {
                        $menu['permissions'] = array_merge($menu['permissions'], $child['permissions']);
                    }
                }
            }
        }

        return $menus;
    }

    /**
     * Puts user permissions in an array.
     *
     * @return array $user_permissions Permissions of the current user
     */
    public static function userPermissions()
    {
        $user_roles = auth()->user()->roles;
        $permissions = [];

        foreach($user_roles as $user_role)
        {
            $user_permissions = $user_role->permissions()->pluck('name')->toArray();
            foreach ($user_permissions as $permission)
            {
                $permissions[] = $permission;
            }
        }

        return $permissions;
    }
}
