<?php

namespace App;

use App\Models\TwoFactor;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Modules\Address\Entities\Address;
use Modules\Order\Entities\Order;
use Modules\Page\Entities\Page;
use Modules\Payment\Entities\Payment;
use Modules\Product\Entities\Product;
use Modules\Ticket\Entities\Ticket;
use Modules\Order\Entities\OrderLog;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable /*Implements MustVerifyEmail*/
{
    use Notifiable;
    use HasRoles;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'mobile',
        'national_code',
        'organization_name',
        'password',
        'mobile_verified_at',
        'two_factor_activated',
        'two_factor_verified_at',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    public function getAvatarAttribute()
    {
        return 'https://www.gravatar.com/avatar/' . md5(strtolower(trim($this->email))) . '?s=160';
    }

    public function getMiniAvatarAttribute()
    {
        return 'https://www.gravatar.com/avatar/' . md5(strtolower(trim($this->email))) . '?s=45';
    }

    public function getNameAttribute()
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    public function addresses()
    {
        return $this->hasMany(Address::class,);
    }

    public function latestAddress()
    {
        return $this->addresses()->get()->last();
    }

    public function hasAddress()
    {
        return $this->latestAddress() ? true : false;
    }

    public function pages()
    {
        return $this->hasMany(Page::class);
    }

    public function tickets()
    {
        return $this->hasMany(Ticket::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    public function twoFactorTokens()
    {
        return $this->hasMany(TwoFactor::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function twoFactorCode()
    {
        return $this->twoFactorTokens()->latest()->first();
    }

    public function wishlist()
    {
        return $this->belongsToMany(Product::class, 'wishlist')->withPivot('is_notification');
    }

    public function wishlists()
    {
        return $this->belongsToMany(Product::class, 'wishlist')->wherePivot('is_notification', false);
    }
	
	public function notifications()
    {
        return $this->belongsToMany(Product::class, 'wishlist')->wherePivot('is_notification', true);
    }

}
