@extends('admin.layouts.app')
@section('content')
    <div class="row">
        <!-- Left col -->
        <section class="col-lg-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">نقش‌های کاربری</h3>
                    <div class="box-tools">
                        <a href="{{ route('admin.roles.create') }}" class="btn btn-default btn-sm">
                            <span class="fa fa-plus"></span>
                            افزودن نقش کاربری
                        </a>
                    </div>
                </div>
                <div class="content">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>نام</th>
                                <th>نام نمایشی</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse($roles as $role)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $role->name }}</td>
                                    <td>{{ $role->display_name }}</td>
                                    <td>
                                        <form method="post" action="{{ route('admin.roles.destroy', $role->id) }}" style="display: inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <a href="{{ route('admin.permissions.edit', $role->id) }}" class="btn btn-default btn-xs" data-toggle="tooltip"  data-placement="top" title="تخصیص دسترسی">
                                                <span class="fa fa-key"></span>
                                            </a>
                                            <a href="{{ route('admin.roles.edit', $role->id) }}" class="btn btn-primary btn-xs" data-toggle="tooltip"  data-placement="top" title="ویرایش">
                                                <span class="fa fa-edit"></span>
                                            </a>
                                            <button type="submit" name="delete" class="btn btn-danger btn-xs" data-toggle="tooltip"  data-placement="top" title="حذف">
                                                <span class="fa fa-trash"></span>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr class="text-center">
                                    <td colspan="3">هیچ گروه کاربری یافت نشد!</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                    {{ $roles->links() }}
                </div>
            </div>

        </section>
        <!-- /.Left col -->
    </div>
@endsection
