@extends('admin.layouts.app')

@section('content')
<div class="row">
    <div class="col-xs-12">
        <div class="box">
            <div class="box-header with-border">
                <h3 class="box-title">تنظیمات سایت</h3>
            </div>
            <!-- /.box-header -->
            <div class="box-body table-responsive no-padding">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>عنوان تنظیمات</th>
                            <th>محتوا</th>
                            <th>عملیات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($settings as $setting)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $setting->label }}</td>
                            <td>{{ substr($setting->value, 0, 50) }}</td>
                            <td>
                                <a href="{{ route('admin.settings.edit', $setting->id) }}" class="btn btn-primary btn-xs" data-toggle="tooltip" data-placement="top" title="ویرایش">
                                    <span class="fa fa-edit"></span>
                                </a>
                            </td>
                        </tr>
                        @endforeach
                        @unless(count($settings))
                            <tr class="text-center">
                                <td colspan="4">هیچ تنظیماتی یافت نشد!</td>
                            </tr>
                        @endunless
                    </tbody>
                </table>
            </div>
            <!-- /.box-body -->
        </div>
        <!-- /.box -->
    </div>
</div>
<!-- /.row -->
@endsection
