@extends('admin.layouts.app')

@section('styles')
@endsection

@section('scripts')
@endsection

@section('content')
    <div class="row">
        <!-- Left col -->
        <section class="col-lg-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">افزودن کاربر بلاک شده</h3>

                    <div class="box-tools">
                        <div class="input-group input-group-sm">
                            <a href="{{ route('admin.blocked_users.index') }}" class="btn btn-default btn-sm">لیست کاربران بلاک شده
                                <span class="fa fa-arrow-left"></span>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="box-body">
                    <form action="{{ route('admin.blocked_users.store') }}" method="post" enctype="multipart/form-data" class="form-horizontal">
                        @csrf
                        <div class="form-group">
                            <label for="name" class="col-md-2 control-label">نام</label>
                            <div class="col-md-2">
                                <input id="name" type="text" class="form-control" name="name" value="{{ old('name') }}">
                                @if($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <label for="mobile" class="col-md-2 control-label">شماره موبایل</label>
                            <div class="col-md-2">
                                <input id="mobile" type="text" class="form-control" name="mobile" value="{{ old('mobile') }}" dir="ltr" maxlength="11">
                                @if($errors->has('mobile'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('mobile') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <label for="national_code" class="col-md-2 control-label">کدملی</label>
                            <div class="col-md-2">
                                <input id="national_code" type="text" class="form-control" name="national_code" value="{{ old('national_code') }}" maxlength="10">
                                @if($errors->has('national_code'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('national_code') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">افزودن کاربر</button>
                    </form>
                </div>
            </div>
        </section>
        <!-- /.Left col -->
    </div>
@endsection
