@extends('admin.layouts.app')

@section('styles')
    <style>
        .table-responsive {
            overflow-x: hidden;
        }
    </style>
    <link rel="stylesheet" href="{{ asset('dashboard/plugins/yajra/js/datatables/dataTables.bootstrap.css') }}">
@endsection

@section('scripts')
    <script src="{{ asset('dashboard/plugins/yajra/js/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('dashboard/plugins/yajra/js/datatables/dataTables.bootstrap.min.js') }}"></script>
    <script src="{{ asset('dashboard/plugins/yajra/js/datatables/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('dashboard/plugins/yajra/js/datatables/jszip.min.js') }}"></script>
    <script src="{{ asset('dashboard/plugins/yajra/js/datatables/pdfmake.min.js') }}"></script>
    <script src="{{ asset('dashboard/plugins/yajra/js/datatables/vfs_fonts.js') }}"></script>
    <script src="{{ asset('dashboard/plugins/yajra/js/datatables/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('dashboard/plugins/yajra/js/datatables/buttons.print.min.js') }}"></script>
    <script src="{{ asset('dashboard/plugins/yajra/js/simple_numbers_no_ellipses.js') }}"></script>
    <script>
        $.fn.DataTable.ext.pager.simple_numbers_no_ellipses = function(page, pages){
            var numbers = [];
            var buttons = $.fn.DataTable.ext.pager.numbers_length;
            var half = Math.floor( buttons / 2 );
            var _range = function ( len, start ){
                var end;
                if ( typeof start === "undefined" ){
                    start = 0;
                    end = len;

                }
                else {
                    end = start;
                    start = len;
                }
                var out = [];
                for ( var i = start ; i < end; i++ ){ out.push(i); }
                return out;
            };

            if ( pages <= buttons ) {
                numbers = _range( 0, pages );
            }
            else if ( page <= half ) {
                numbers = _range( 0, buttons);
            }
            else if ( page >= pages - 1 - half ) {
                numbers = _range( pages - buttons, pages );
            }
            else {
                numbers = _range( page - half, page + half + 1);
            }
            numbers.DT_el = 'span';
            return [ 'previous', numbers, 'next' ];
        };
    </script>
    <script>
        $(document).ready(function() {
            $('#users').DataTable({
                processing: true,
                order: [[ 0, "asc" ]],
                language: {
                    "url": "{{ asset('dashboard/plugins/yajra/i18n/Persian.json') }}"
                },
                pagingType: "simple_numbers_no_ellipses",
                lengthMenu: [
                    [25, 50, 100, 250],
                    [25, 50, 100, 250]
                ],
            });
        });
    </script>
@endsection

@section('content')
    <div class="row">
        <!-- Left col -->
        <section class="col-lg-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">کاربران</h3>

                    <div class="box-tools">
                        <div class="input-group input-group-sm">
                            <a href="{{ route('admin.blocked_users.create') }}" class="btn btn-default btn-sm">
                                <span class="fa fa-plus"></span> افزودن کابر
                            </a>
                        </div>
                    </div>
                </div>
                <div class="box-body table-responsive no-padding">
                    <table class="table table-bordered table-hover table-striped table-condensed" id="users">
                        <thead>
                        <tr>
                            <td>#</td>
                            <td>نام و نام خانوادگی</td>
                            <td>موبایل</td>
                            <td>کدملی</td>
                            <td>تاریخ درج</td>
                            <td>عملیات</td>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($users as $user)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $user->name }}</td>
                                <td>{{ $user->mobile }}</td>
                                <td>{{ $user->national_code }}</td>
                                <td>
                                    <span dir="ltr">{{ jdate($user->created_at)->format('Y/m/d H:i:s') }}</span>
                                </td>
                                <td>
                                    <form action="{{ route('admin.blocked_users.destroy', $user->id) }}" method="post">
                                        @csrf
                                        @method('delete')
                                        <button type="submit" class="btn btn-danger btn-xs" name="delete" value="1" onclick="return confirm('آیا از حذف کاربر مطمئن هستید؟');" data-toggle="tooltip"  data-placement="top" title="حذف">
                                            <span class="fa fa-trash"></span>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                        @unless(count($users))
                            <tr class="text-center">
                                <td colspan="6">هیچ کاربری یافت نشد!</td>
                            </tr>
                        @endunless
                        </tbody>
                    </table>
                </div>
            </div>

        </section>
        <!-- /.Left col -->
    </div>
@endsection
