@extends('admin.layouts.app')

@section('styles')
    <link rel="stylesheet" href="{{ asset('dashboard/plugins/select2/select2.min.css') }}">
    <style>
        .select2-selection__choice {
            color: #666 !important;
        }

        .select2-container {
            width: 100% !important;
        }

        .select2-search__field {
            width: 100% !important;
        }
    </style>
@endsection

@section('scripts')
    <script src="{{ asset('dashboard/plugins/select2/select2.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('.select2').select2({
                placeholder: 'انتخاب کنید',
            });
        });
    </script>
@endsection

@section('content')
    <div class="row">
        <!-- Left col -->
        <section class="col-lg-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">افزودن کاربر</h3>

                    <div class="box-tools">
                        <div class="input-group input-group-sm">
                            <a href="{{ route('admin.users.index') }}" class="btn btn-default btn-sm">لیست کابران
                                <span class="fa fa-arrow-left"></span>
                            </a>
                        </div>
                    </div>
                </div>
                <div class="box-body">
                    <form action="{{ route('admin.users.store') }}" method="post" enctype="multipart/form-data" class="form-horizontal">
                        @csrf
                        <div class="form-group">
                            <label for="first_name" class="col-md-2 control-label">نام</label>
                            <div class="col-md-4">
                                <input id="first_name" type="text" class="form-control" name="first_name" value="{{ old('first_name') }}">
                                @if ($errors->has('first_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('first_name') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <label for="last_name" class="col-md-2 control-label">نام خانوادگی</label>
                            <div class="col-md-4">
                                <input id="last_name" type="text" class="form-control" name="last_name" value="{{ old('last_name') }}">
                                @if ($errors->has('last_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('last_name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="role" class="col-md-2 control-label">گروه کاربری</label>
                            <div class="col-md-4">
                                <select name="role" id="role" class="form-control">
                                    @foreach($roles as $id => $role)
                                        <option value="{{ $id }}"{{ (old('role') == $id ? ' selected' : '') }}>{{ $role }}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('role'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('role') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="email" class="col-md-2 control-label">پست الکترونیک</label>
                            <div class="col-md-4">
                                <input id="email" type="email" class="form-control" name="email" value="{{ old('email') }}" dir="ltr">
                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <label for="mobile" class="col-md-2 control-label">شماره همراه</label>
                            <div class="col-md-4">
                                <input id="mobile" type="text" class="form-control" name="mobile" value="{{ old('mobile') }}" dir="ltr" maxlength="11">
                                @if ($errors->has('mobile'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('mobile') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="city" class="col-md-2 control-label">شهر</label>
                            <div class="col-md-4">
                                <select name="city" id="city" class="form-control select2">
                                    @foreach($provinces as $province)
                                        <optgroup label="{{ $province->name }}">
                                            @foreach($province->cities as $city)
                                                <option value="{{ $city->id }}"{{ (old('city') == $city->id ? ' selected' : '') }}>{{ $city->name }}</option>
                                            @endforeach
                                        </optgroup>
                                    @endforeach
                                </select>
                                @if ($errors->has('city'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('city') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <label for="phone" class="col-md-2 control-label">تلفن</label>
                            <div class="col-md-4">
                                <input id="phone" type="text" class="form-control" name="phone" value="{{ old('phone') }}" dir="ltr">
                                @if ($errors->has('phone'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('phone') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="post_code" class="col-md-2 control-label">کدپستی</label>
                            <div class="col-md-4">
                                <input id="post_code" type="text" class="form-control" name="post_code" value="{{ old('post_code') }}" dir="ltr" maxlength="10">
                                @if ($errors->has('post_code'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('post_code') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <label for="password" class="col-md-2 control-label">رمزعبور</label>
                            <div class="col-md-4">
                                <input id="password" type="password" class="form-control" name="password" value="{{ old('password') }}">

                                @if ($errors->has('password'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="address" class="col-md-2 control-label">آدرس کامل</label>
                            <div class="col-md-10">
                                <textarea id="address" type="text" class="form-control" name="address" rows="5">{{ old('address') }}</textarea>
                                @if ($errors->has('address'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('address') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">افزودن کاربر</button>
                    </form>
                </div>
            </div>

        </section>
        <!-- /.Left col -->
    </div>
@endsection
