@extends('frontend.layouts.app')

@section('styles')
    <style>
        .field-password-icon {
            z-index: 3;
            position: absolute;
            left: 10px;
            margin-top: 9px;
            cursor: pointer;
        }
        .field-otp-password-icon {
            z-index: 3;
            position: relative;
            left: 25px;
            margin-top: 9px;
            cursor: pointer;
        }
    </style>
@endsection

@section('title', 'ورود')

@section('scripts')
    <script>
        $(".toggle-password").click(function() {
            $(this).toggleClass("fa-eye fa-eye-slash");
            if ($('#password').attr("type") == "password") {
                $('#password').attr("type", "text");
            }
            else {
                $('#password').attr("type", "password");
            }
        });
    </script>
@endsection

@section('content')
    <div class="container-fluid body-section">
        <div class="container">
            <div class="row my-5">
                <div class="col col-12 col-md-6 col-lg-5 mx-auto">
                    <div class="card card-body">
                        <form class="form-login-out" method="POST" action="{{ route('login') }}" enctype="multipart/form-data" id="login-form">
                            @csrf
                            <div class="inbox-form">
                                <h3 class="title-box text-center font-weight-bold position-relative"> ورود به سایت</h3>
                                <br>
                                @if($errors->any())
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <div class="form-group">
                                    <label for="mobile" class="mb-2">شماره موبایل</label>
                                    <input type="text" name="mobile" class="form-control" id="mobile" value="{{ old('mobile') }}" maxlength="11" autofocus>
                                    @if ($errors->has('mobile'))
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{$errors->first('mobile')}}</strong>
                                        </span>
                                    @endif
                                </div>
                                <div class="form-group">
                                    <label for="password" class="mb-2">رمزعبور</label>
                                    <div class="input-group">
                                        <input type="password" name="password" class="form-control" id="password" value="">
                                        <span toggle="#password-field" class="fa fa-fw fa-eye field-password-icon toggle-password"></span>
                                        @if ($errors->has('password'))
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{$errors->first('password')}}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>

                                <div class="form-check mt-3 mb-2">
                                    <input type="checkbox" class="form-check-input" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="remember">مرا به خاطر بسپار</label>
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary form-control">
                                        <i class="login-icon"></i>
                                        <span class="txt-btn-reg">ورود به سایت</span>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
