@extends('frontend.layouts.app')

@section('title', 'بازیابی کلمه عبور')

@section('styles')
    <link href="{{ asset('css/account.css') }}" rel="stylesheet">
@endsection

@section('content')
    <div class="container cont-categori">
        <div class="row my-5">
            <div class="col col-12 col-md-6 col-lg-5 mx-auto">
                <div class="card card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    <form class="form-login-out" method="POST" action="{{ route('password.sms') }}">
                        @csrf
                        <h3 class="title-box text-center font-weight-bold position-relative"> بازیابی رمزعبور</h3>
                        <br>
                        <div class="form-group row">
                            <label for="mobile" class="col col-md-12 col-lg-12 col-12 col-form-label">شماره موبایل</label>
                            <div class="col col-md-12 col-lg-12 col-12">
                                <input id="mobile" type="text" class="form-control{{ $errors->has('mobile') ? ' is-invalid' : '' }}" name="mobile" value="{{ old('mobile') }}" required maxlength=11>
                                @if ($errors->has('mobile'))
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('mobile') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="form-group row mt-4 mb-0">
                            <div class="col col-md-12 col-lg-12 col-12 text-center">
                                <button type="submit" class="btn btn-primary btn-block">
                                    بازیابی
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection