@extends('frontend.layouts.app')

@section('title', 'بازیابی رمزعبور')

@section('styles')
    <link href="{{ asset('css/account.css') }}" rel="stylesheet">
    <style>
        .field-password-icon {
            z-index: 3;
            position: absolute;
            left: 10px;
            margin-top: 9px;
            cursor: pointer;
        }
        .field-otp-password-icon {
            z-index: 3;
            position: relative;
            left: 25px;
            margin-top: 9px;
            cursor: pointer;
        }
    </style>
@endsection

@section('scripts')
    <script>
        $(".toggle-password").click(function() {

            $(this).toggleClass("fa-eye fa-eye-slash");

            if ($('#password').attr("type") == "password") {
                $('#password').attr("type", "text");
            } else {
                $('#password').attr("type", "password");
            }
        });
        $(".toggle-password-confirmation").click(function() {

            $(this).toggleClass("fa-eye fa-eye-slash");

            if ($('#password-confirm').attr("type") == "password") {
                $('#password-confirm').attr("type", "text");
            } else {
                $('#password-confirm').attr("type", "password");
            }
        });
    </script>
@endsection

@section('content')
    <div class="container cont-categori">
        <div class="row my-5">
            <div class="col col-12 col-md-6 col-lg-5 mx-auto">
                <div class="card card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    <form method="POST" action="{{ route('password.update') }}" autocomplete="off">
                        @csrf
                        <h3 class="title-box text-center font-weight-bold position-relative"> بازیابی رمزعبور</h3>
                        <br>
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <input type="hidden" name="mobile" value="{{ $mobile }}">
                        <div class="input-group input-group-lg mb-3">
                            <label for="code" class="col-md-4 col-form-label text-md-right">کد ارسالی</label>
                            <input id="code" type="text" class="form-control{{ $errors->has('code') ? ' is-invalid' : '' }}" name="code" value="{{ old('code') }}" autocomplete="new-password" required autofocus>
                            @if ($errors->has('code'))
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('code') }}</strong>
                                </span>
                            @endif
                        </div>

                        <div class="input-group input-group-lg mb-3">
                            <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('Password') }}</label>
                            <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" autocomplete="new-password" required>
                            <span toggle="#password-field" class="fa fa-fw fa-eye field-password-icon toggle-password"></span>
                            @if ($errors->has('password'))
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $errors->first('password') }}</strong>
                                </span>
                            @endif
                        </div>

                        <div class="input-group input-group-lg mb-3">
                            <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('Confirm Password') }}</label>
                            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required>
                            <span toggle="#password-field" class="fa fa-fw fa-eye field-password-icon toggle-password-confirmation"></span>
                        </div>

                        <div class="form-group row mt-3 mb-0">
                            <div class="col col-md-12 col-lg-12 col-12 p-0 text-center">
                                <button type="submit" class="btn btn-primary btn-block">
                                    به روزرسانی رمزعبور
                                </button>
                            </div>
                        </div>
                        <div class="form-group row mt-2 mb-0">
                            <div class="col col-md-12 col-lg-12 col-12 text-center">
                                <a href="{{ route('password.request') }}" class="btn btn-default btn-sm">
                                    کد را دریافت نکردم
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
