@extends('frontend.layouts.app')

@section('title', 'اعتبارسنجی')

@section('styles')
    <style>
        .input-group-addon:first-child {
        	border-right: 1px solid #ccc !important;
        	width: 50px;
        	text-align: center;
        	border-top: 1px solid #ccc !important;
        	border-bottom: 1px solid #ccc !important;
        	background-color: #fafafa;
        	color: #b4b4b4;
        	display: grid;
        	align-items: center;
        }
    </style>
@endsection

@section('scripts')
    <script>
        $('.sendCode').click(function () {
            var mobile        = $('#mobile').val();
            var national_code = $('#national_code').val();
            if (mobile.length!=11 || national_code.length!=10) {
                alert('لطفا اطلاعات را به درستی وارد نمائید.');
                return false;
            }

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'post',
                url: "{{ route('send.verification_code') }}",
                data: {
                    mobile: mobile,
                    national_code: national_code,
                },
            }).done(function(response) {
                var data = jQuery.parseJSON(response);
                if (data.status=='NOK') {
                    alert('متاسفانه امکان احراز هویت شما وجود ندارد.');
                }
                else {
                    $('#code-div').append('<div class="col col-12 col-md-6 col-lg-6 mb-3"><label for="code" class="mb-2">کد دریافتی</label><input type="text" name="code" id="code" class="form-control" maxlength="6" required></div>');
                    $('.sendCode').remove();
                    $('#send-data-btn').show();
                    $('#order_id').val(data.buyer_id);
                }
            });
        });

        $('.sendData').click(function () {
            var mobile        = $('#mobile').val();
            var national_code = $('#national_code').val();
            var code          = $('#code').val();

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'post',
                url: "{{ route('check.verification_code') }}",
                data: {
                    mobile: mobile,
                    national_code: national_code,
                    code: code,
                },
            }).done(function(response) {
                var data = jQuery.parseJSON(response);
                if (data.status=='NOK') {
                    alert('متاسفانه امکان احراز هویت شما وجود ندارد.');
                }
                else {
                    $("#form").attr('action', data.url);
                    $("#form").submit();
                }
            });
        });
    </script>
@endsection

@section('content')
    <div class="col col-12 bg-primary text-white text-center h5 border rounded shadow-sm p-3 mb-0">
        <i class="fa fa-sign-in"></i>
        ورود به درگاه
    </div>
    <div class="col col-12 border rounded shadow-sm p-3 mb-3">
        <p class="mb-5">{{ $description }}</p>
    
        @if($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <form method="post" action="" id="form">
            @csrf
            <input type="hidden" name="order_id" id="order_id" value="">
            <div class="row">
                <div class="col col-12 col-md-6 col-lg-6 mb-3">
                    <label for="mobile" class="mb-2">شماره تلفن همراه</label>
                    <div class="input-group input-group-lg">
                        <span class="input-group-addon" id="usericon">
                            <i class="fa fa-mobile" aria-hidden="true"></i>
                        </span>
                        <input type="text" name="mobile" id="mobile" class="form-control" maxlength="11" required>
                    </div>
                </div>
                <div class="col col-12 col-md-6 col-lg-6 mb-3">
                    <label for="national_code" class="mb-2">کدملی</label>
                    <div class="input-group input-group-lg">
                        <span class="input-group-addon" id="usericon">
                            <i class="fa fa-address-card" aria-hidden="true"></i>
                        </span>
                        <input type="text" name="national_code" id="national_code" class="form-control" maxlength="10" required>
                    </div>
                </div>
                <div id="code-div"></div>
            </div>
            <div class="row">
                <div class="col col-12 col-md-6 col-lg-6 mx-auto text-center mb-3">
                    <input type="radio" name="pay_gate" id="pay_gate_zarinpal" value="zarinpal" checked>
                    <label for="pay_gate_zarinpal">درگاه زرین پال</label>
                </div>
                <div class="col col-12 mx-auto text-center">
                    <button type="button" class="btn btn-success sendCode">ارسال کد</button>
                    <button type="button" class="btn btn-success sendData" id="send-data-btn" style="display:none">ورود به درگاه</button>
                </div>
            </div>
        </form>
    </div>
@endsection