<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Auth::routes(['verify' => false]);

Route::post('/send-verification-code', 'AppController@sendVerificationCode')->name('send.verification_code')->middleware('throttle:10,3');
Route::post('/check-verification-code', 'AppController@checkVerificationCode')->name('check.verification_code');

Route::prefix('admin')->name('admin.')->namespace('Admin')->group(function() {
    Route::resource('roles', 'RoleController')->except('show');
    Route::resource('permissions', 'PermissionController')->only('update', 'edit');
});

Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    // return what you want
});