

<?php $__env->startSection('title', 'اعتبارسنجی'); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .input-group-addon:first-child {
        	border-right: 1px solid #ccc !important;
        	width: 50px;
        	text-align: center;
        	border-top: 1px solid #ccc !important;
        	border-bottom: 1px solid #ccc !important;
        	background-color: #fafafa;
        	color: #b4b4b4;
        	display: grid;
        	align-items: center;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $('.sendCode').click(function () {
            var mobile        = $('#mobile').val();
            var national_code = $('#national_code').val();
            if (mobile.length!=11 || national_code.length!=10) {
                alert('لطفا اطلاعات را به درستی وارد نمائید.');
                return false;
            }

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'post',
                url: "<?php echo e(route('send.verification_code')); ?>",
                data: {
                    mobile: mobile,
                    national_code: national_code,
                },
            }).done(function(response) {
                var data = jQuery.parseJSON(response);
                if (data.status=='NOK') {
                    alert('متاسفانه امکان احراز هویت شما وجود ندارد.');
                }
                else {
                    $('#code-div').append('<div class="col col-12 col-md-6 col-lg-6 mb-3"><label for="code" class="mb-2">کد دریافتی</label><input type="text" name="code" id="code" class="form-control" maxlength="6" required></div>');
                    $('.sendCode').remove();
                    $('#send-data-btn').show();
                    $('#order_id').val(data.buyer_id);
                }
            });
        });

        $('.sendData').click(function () {
            var mobile        = $('#mobile').val();
            var national_code = $('#national_code').val();
            var code          = $('#code').val();

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'post',
                url: "<?php echo e(route('check.verification_code')); ?>",
                data: {
                    mobile: mobile,
                    national_code: national_code,
                    code: code,
                },
            }).done(function(response) {
                var data = jQuery.parseJSON(response);
                if (data.status=='NOK') {
                    alert('متاسفانه امکان احراز هویت شما وجود ندارد.');
                }
                else {
                    $("#form").attr('action', data.url);
                    $("#form").submit();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="col col-12 bg-primary text-white text-center h5 border rounded shadow-sm p-3 mb-0">
        <i class="fa fa-sign-in"></i>
        ورود به درگاه
    </div>
    <div class="col col-12 border rounded shadow-sm p-3 mb-3">
        <p class="mb-5"><?php echo e($description); ?></p>
    
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <form method="post" action="" id="form">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="order_id" id="order_id" value="">
            <div class="row">
                <div class="col col-12 col-md-6 col-lg-6 mb-3">
                    <label for="mobile" class="mb-2">شماره تلفن همراه</label>
                    <div class="input-group input-group-lg">
                        <span class="input-group-addon" id="usericon">
                            <i class="fa fa-mobile" aria-hidden="true"></i>
                        </span>
                        <input type="text" name="mobile" id="mobile" class="form-control" maxlength="11" required>
                    </div>
                </div>
                <div class="col col-12 col-md-6 col-lg-6 mb-3">
                    <label for="national_code" class="mb-2">کدملی</label>
                    <div class="input-group input-group-lg">
                        <span class="input-group-addon" id="usericon">
                            <i class="fa fa-address-card" aria-hidden="true"></i>
                        </span>
                        <input type="text" name="national_code" id="national_code" class="form-control" maxlength="10" required>
                    </div>
                </div>
                <div id="code-div"></div>
            </div>
            <div class="row">
                <div class="col col-12 col-md-6 col-lg-6 mx-auto text-center mb-3">
                    <input type="radio" name="pay_gate" id="pay_gate_zarinpal" value="zarinpal" checked>
                    <label for="pay_gate_zarinpal">درگاه زرین پال</label>
                </div>
                <div class="col col-12 mx-auto text-center">
                    <button type="button" class="btn btn-success sendCode">ارسال کد</button>
                    <button type="button" class="btn btn-success sendData" id="send-data-btn" style="display:none">ورود به درگاه</button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/digigiftpay/laravel/resources/views/frontend/form.blade.php ENDPATH**/ ?>