<?php
require_once "checklogin.php";
require_once "../classes/admin.php";


$msg = '';
$color = 'success';

if (isset($_GET['delete'])) {
    $msg = 'حذف  ادمین با موفقیت انجام شد';

    $color = 'danger';

}

if (isset($_GET['update']) && ($_GET['update']) == "success") {
    $msg = 'ویرایش  ادمین با موفقیت انجام شد';
    $color = 'info';

}

if (isset($_GET['add']) && ($_GET['add']) == "success") {
    $msg = 'ثبت  ادمین با موفقیت انجام شد';
    $color = 'success';

}
?>

<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>

    <meta charset="utf-8"/>
    <title> اطلاعات مدیران</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description"/>
    <meta content="Coderthemes" name="author"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- third party css -->
    <link href="assets/libs/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css"/>
    <link href="assets/libs/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet"
          type="text/css"/>
    <link href="assets/libs/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet"
          type="text/css"/>
    <link href="assets/libs/datatables.net-select-bs5/css//select.bootstrap5.min.css" rel="stylesheet" type="text/css"/>
    <!-- third party css end -->

    <!-- App css -->
    <link href="assets/css/config/default/bootstrap-rtl.min.css" rel="stylesheet" type="text/css"
          id="bs-default-stylesheet"/>
    <link href="assets/css/config/default/app-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-default-stylesheet"/>

    <link href="assets/css/config/default/bootstrap-dark.min.css" rel="stylesheet" type="text/css"
          id="bs-dark-stylesheet" disabled="disabled"/>
    <link href="assets/css/config/default/app-dark-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-dark-stylesheet" disabled="disabled"/>

    <!-- icons -->
    <link href="assets/css/icons-rtl.min.css" rel="stylesheet" type="text/css"/>

</head>

<!-- body start -->
<body class="loading"
      data-layout='{"mode": "light", "width": "fluid", "menuPosition": "fixed", "sidebar": { "color": "light", "size": "default", "showuser": true}, "topbar": {"color": "light"}, "showRightSidebarOnPageLoad": true}'>

<!-- Begin page -->
<div id="wrapper">


    <!-- Topbar Start -->
    <?php include_once "tobbar.php"; ?>
    <!-- end Topbar -->

    <!-- ========== Left Sidebar Start ========== -->
    <?php include_once "sidebar.php"; ?>
    <!-- Left Sidebar End -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content">

            <!-- Start Content-->
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">

                            <?php

                            if ($msg != '') {
                                ?>
                                <div class="alert alert-<?= $color ?> alert-dismissible fade show"
                                     style="margin-top: 15px"
                                     role="alert">
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                            aria-label="Close"></button>
                                    <?php
                                    echo $msg;
                                    ?>
                                </div>
                                <?php
                            }
                            ?>

                            <div class="card-body">
                                <h4 class="mt-0 header-title">لیست ادمین</h4>
                         </br>
                                <div class="row">
                                    <div class="col-xl-4 col-lg-4 col-md-4 col-xs-12 col-sm-12">
                                        <a href="save_admin.php">
                                            <button type="button"
                                                    class="btn btn-success waves-effect waves-light">
                                                افزودن ادمین
                                            </button>
                                        </a>
                                    </div>
                                </div>
                                <table id="datatable"
                                       class="table table-striped table-sm dt-responsive table-responsive nowrap">
                                    <thead class="table-success">
                                    <tr>
                                        <th>شناسه</th>
                                        <th>نام</th>
                                        <th>نام کاربری</th>
                                        <th>تصویر</th>
                                        <th> ایمیل</th>
                                        <th>عملیات</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    $admin = new Admin();
                                    foreach ($admin->viewAll(5) as $key => $value) {
                                        ?>
                                        <td> <?= $value['id'] ?> </td>
                                        <td> <?= $value['name'] ?> </td>
                                        <td> <?= $value['username'] ?> </td>
                                        <td><img class="img-fluid avatar-lg rounded"
                                                 src="../image/admin/<?php echo $value['avatar'] ?>"></td>

                                        <td><?= $value['email'], ' ', $value['phone'] ?></td>
                                        <td><a href="delete.php?action=deleteadmin&id=<?php echo $value['id'] ?>"
                                            <button type="button"
                                                    class="btn  btn-xs btn-outline-danger waves-effect waves-light"></button>
                                            حذف</a>
                                            <a href="save_admin.php?action=edit&id=<?php echo $value['id'] ?>"
                                            <button type="button"
                                                    class="btn  btn-xs btn-outline-info waves-effect waves-light">
                                                ویرایش
                                            </button>
                                            </a>
                                        </td>
                                        </tr>
                                        <?php
                                    } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end row -->
            </div> <!-- container -->
        </div> <!-- content -->

        <!-- Footer Start -->
        <?php include_once "footer.php"; ?>
        <!-- end Footer -->

    </div>
    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->

</div>
<!-- END wrapper -->

<!-- Right Sidebar -->
<?php include_once "rsidebar.php"; ?>
<!-- /Right-bar -->

<!-- Right bar overlay-->
<div class="rightbar-overlay"></div>

<!-- Vendor js -->
<script src="assets/js/vendor.min.js"></script>

<!-- knob plugin -->
<script src="assets/libs/jquery-knob/jquery.knob.min.js"></script>


<!-- third party js -->
<script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
<script src="assets/libs/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
<script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
<script src="assets/libs/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
<script src="assets/libs/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/buttons.flash.min.js"></script>
<script src="assets/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
<script src="assets/libs/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
<script src="assets/libs/datatables.net-select/js/dataTables.select.min.js"></script>
<script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
<script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>
<!-- third party js ends -->

<!-- Datatables init -->
<script>
    $(document).ready(function () {

        $("#datatable").DataTable(
            {
                dom: 'Bftip',
                responsive: true,
                buttons: [],
                language: {
                    "decimal": "",
                    "emptyTable": "اطلاعاتی در این جدول وجود ندارد",
                    "info": "نمایش _START_ تا _END_ از _TOTAL_ نتیجه",
                    "infoEmpty": "نمایش 0 تا 0 از 0 نتیجه",
                    "infoFiltered": "(فیلتر شده از _MAX_  نتیجه)",
                    "infoPostFix": "",
                    "thousands": ",",
                    "lengthMenu": "Show _MENU_ entries",
                    "loadingRecords": "در حال بارگذاری اطلاعات...",
                    "processing": "",
                    "search": "جستجو:",
                    "zeroRecords": "هیچ نتیجه ای پیدا نشد",
                    "paginate": {
                        "first": "اولین",
                        "last": "آخرین",
                        "next": "بعدی",
                        "previous": "قبلی"
                    },
                    "aria": {
                        "orderable": "Order by this column",
                        "orderableReverse": "Reverse order this column"
                    }
                }
            }
        );
        //     var a = $("#datatable-buttons").DataTable({
        //         lengthChange: !1,
        //         buttons: ["copy", "excel", "pdf"]
        //     });
        //     $("#key-table").DataTable({
        //         keys: !0
        //     }), $("#responsive-datatable").DataTable(), $("#selection-datatable").DataTable({
        //         select: {
        //             style: "multi"
        //         }
        //     }), a.buttons().container().appendTo("#datatable-buttons_wrapper .col-md-6:eq(0)"), $("#datatable_length select[name*='datatable_length']").addClass("form-select form-select-sm"), $("#datatable_length select[name*='datatable_length']").removeClass("custom-select custom-select-sm"), $(".dataTables_length label").addClass("form-label")
    });
</script>

<!-- App js -->
<script src="assets/js/app.min.js"></script>


</body>
</html>