<?php
require_once "checklogin.php";
require_once "../classes/user.php";
require_once "../classes/class-logs.php";
include_once '../classes/jdf.php';
require_once "../classes/invoice.php";

$user = new User();
$invoice = new Invoice();
?>
<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>

    <meta charset="utf-8"/>
    <title>داشبورد</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description"/>
    <meta content="Coderthemes" name="author"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- App css -->
    <link href="assets/css/config/default/bootstrap-rtl.min.css" rel="stylesheet" type="text/css"
          id="bs-default-stylesheet"/>
    <link href="assets/css/config/default/app-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-default-stylesheet"/>

    <link href="assets/css/config/default/bootstrap-dark.min.css" rel="stylesheet" type="text/css"
          id="bs-dark-stylesheet" disabled="disabled"/>
    <link href="assets/css/config/default/app-dark-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-dark-stylesheet" disabled="disabled"/>

    <!-- icons -->
    <link href="assets/css/icons-rtl.min.css" rel="stylesheet" type="text/css"/>
</head>

<!-- body start -->
<body class="loading"
      data-layout='{"mode": "light", "width": "fluid", "menuPosition": "fixed", "sidebar": { "color": "light", "size": "default", "showuser": true}, "topbar": {"color": "light"}, "showRightSidebarOnPageLoad": true}'>

<!-- Begin page -->
<div id="wrapper">


    <!-- Topbar Start -->
    <?php include_once "tobbar.php"; ?>
    <!-- end Topbar -->

    <!-- ========== Left Sidebar Start ========== -->
    <?php include_once "sidebar.php"; ?>
    <!-- Left Sidebar End -->

    <!-- ============================================================== -->
    <!-- Start Page Content here -->
    <!-- ============================================================== -->

    <div class="content-page">
        <div class="content ">
            <!-- Start Content-->
            <div class="row">
                <div class="col-xl-3 col-md-3 text-center">
                    <div class="card text-white bg-primary">
                        <div class="card-body">
                            <blockquote class="card-bodyquote mb-0">
                                <h5>تعداد کاربران کل </h5>
                                <h2 class="fw-normal text-white"
                                <footer class="blockquote-footer text-white"><a href="users.php"
                                class="text-white"> <?= $user->countUsers() ?></a>
                                </footer>
                            </blockquote>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-3 text-center">
                    <div class="card text-white bg-success">
                        <div class="card-body">
                            <blockquote class="card-bodyquote mb-0">
                                <h5>تعداد کاربران احراز شده</h5>
                                <h2 class="fw-normal text-white"
                                <footer class="blockquote-footer text-white-50">
                                    <a href="users.php?st=1"
                                       class="text-white">
                                        <?= $user->countUserEnabled() ?></a>
                                </footer>
                            </blockquote>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-md-3 text-center">
                    <div class="card text-white bg-danger">
                        <div class="card-body">
                            <blockquote class="card-bodyquote mb-0">
                                <h5>تعداد کاربران بلاک شده </h5>
                                <h2 class="fw-normal text-white"
                                <footer class="blockquote-footer text-white-50"><a href="users.php?ban=1"
                                class="text-white"><?= $user->countUserDisbled() ?></a>
                                </footer>
                            </blockquote>
                        </div>
                    </div>
                </div>
   <div class="col-xl-3 col-md-3 text-center">
                    <div class="card text-white bg-warning">
                        <div class="card-body">
                            <blockquote class="card-bodyquote mb-0">
                                <h5>درآمد امروز</h5>
                                <h2 class="fw-normal text-white"
                                <footer class="blockquote-footer text-white-50">
                                <?= $invoice->todayIncome() ?>
                                </footer>
                            </blockquote>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end row -->

        <div class="row">
            <div class="col-xl-9">
                <div class="card border border-primary">
                    <div class="card-body text-primary">
                        <h5 class="card-title text-primary">آخرین صورتحساب ها</h5>
                        <div class="table-responsive">
                            <table class="table table-hover mb-0">
                                <thead>
                                <tr>
                                    <th>شناسه</th>
                                    <th>کاربر</th>
                                    <th>تاریخ </th>
                                    <th>درگاه </th>
                                           <th> مبلغ  </th>
                                    <th> وضعیت کاربر</th>
                                    <th>وضعیت پرداخت</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                $invoice = new Invoice();
                                $user = new User();
                                foreach ($invoice->viewAll(10, 'desc') as $key => $value) { ?>
                                    <tr>
                                        <td> <?= $value['id'] ?> </td>
                                       <td> <?php
                                       $userinfo = $user->getOne($value['userid']);
                                       echo $userinfo['name'] != '' ? $userinfo['name'] : $userinfo['phone'];
                                       ?></td>
                                       
                                        <td> <?= jstrftime('%Y/%m/%e ,%A', $value['created_at']) ?> </td>
                                         <td> <?= $value['gateway'] ?> </td>
                                            <td><?= number_format($value['amount']) ?></td>
                                        <td><?php if ($userinfo['st'] == 1) { ?> <span
                                                    class="badge badge-outline-success"> احراز شده</span>
                                            <?php } else { ?> <span class="badge badge-outline-danger">احراز نشده</span>
                                            <?php } ?>
                                        </td>
                                        <td><?php if ($value['st'] == 1) { ?> <span
                                                    class="badge badge-outline-success">پرداخت شده</span>
                                            <?php } else { ?> <span class="badge badge-outline-danger">پرداخت نشده</span>
                                            <?php } ?>
                                        </td>

                                    </tr>
                                <?php }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-3">
                <div class="card border border-success">
                    <div class="card-body text-success">
                        <h5 class="card-title text-success">آخرین کاربران ثبت شده</h5>
                        <?php
                        $user = new user();
                        foreach ($user->viewAll(10) as $key => $value) { ?>
                            <ul class="list-group mb-0 user-list">
                                <li class="list-group-item">
                                    <a href="save_user.php?action=edit&id=<?=$value['id'] ?>" class="user-list-item">
                                        <div class="user-desc">
                                            <h5 class="name mt-0 mb-1"><?= $value['name'] ?></h5>
                                            <h6 class="name mt-0 mb-1"><?= $value['phone'] ?>
                                        
                                        </div>
                                    </a>
                                </li>
                            </ul>
                        <?php }
                        ?>
                    </div>
                </div>
            </div>
        
      


    </div> <!-- container -->

</div> <!-- content -->


<!-- Footer Start -->
<?php include_once "footer.php"; ?>
    <!-- end Footer -->

    <!-- ============================================================== -->
    <!-- End Page content -->
    <!-- ============================================================== -->

    <!-- END wrapper -->

    <!-- Right Sidebar -->
<?php include_once "rsidebar.php"; ?>
<!-- /Right-bar -->

<!-- Right bar overlay-->
<div class="rightbar-overlay"></div>

<!-- Vendor js -->
<script src="assets/js/vendor.min.js"></script>

<!-- knob plugin -->
<script src="assets/libs/jquery-knob/jquery.knob.min.js"></script>

<!--Morris Chart-->
<script src="assets/libs/morris.js06/morris.min.js"></script>
<script src="assets/libs/raphael/raphael.min.js"></script>

<!-- Dashboar init js-->
<!--<script src="assets/js/pages/dashboard.init.js"></script>-->

<!-- App js-->
<script src="assets/js/app.min.js"></script>

</body>
</html>