<?php

include_once '../classes/db.php';
include_once '../classes/admin.php';

$admin = new Admin();

session_start();
$result = [];
$msg = '';


$email = isset($_POST['email']) ? $_POST['email'] : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';

if (isset($_POST['submit'])) {

    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        if (preg_match('/^[a-zA-Z0-9]{3,30}$/', $password)) {

            $admin->setEmail($email);
            $admin->setPass($password);
            
            $result = $admin->login();
            if ($result['st']) {
                $admin_data= $result['msg'];
                $_SESSION['admin123'] = $admin_data['id'];
                $_SESSION['adminname'] = $admin_data['name'];
                $_SESSION['username'] = $admin_data['username'];

                header("location:index.php");
            } else {
                $msg =$result['msg'];
            }

        } else  $msg = "لطفا پسورد خود را به درستی وارد کنید";
    } else  $msg = "لطفا ایمیل خود را به درستی وارد کنید";
}

?>

<!DOCTYPE html>
<html lang="en" dir="rtl">
<head>
    <meta charset="utf-8"/>
    <title> ورود-دیجی گیفت</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <!-- App favicon -->
    <link rel="shortcut icon" href="assets/images/favicon.ico">

    <!-- App css -->
    <link href="assets/css/config/default/bootstrap-rtl.min.css" rel="stylesheet" type="text/css"
          id="bs-default-stylesheet"/>
    <link href="assets/css/config/default/app-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-default-stylesheet"/>

    <link href="assets/css/config/default/bootstrap-dark.min.css" rel="stylesheet" type="text/css"
          id="bs-dark-stylesheet" disabled="disabled"/>
    <link href="assets/css/config/default/app-dark-rtl.min.css" rel="stylesheet" type="text/css"
          id="app-dark-stylesheet" disabled="disabled"/>

    <!-- icons -->
    <link href="assets/css/icons-rtl.min.css" rel="stylesheet" type="text/css"/>

</head>

<body class="loading authentication-bg authentication-bg-pattern">

<div class="account-pages my-5">
    <div class="container">

        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6 col-xl-4">
                <div class="text-center">
                    <a href="login.php">
                        <img src="#" alt="" height="22" class="mx-auto">
                    </a>
                    <h4><p class="text-muted mt-2 mb-4">پنل مدیریت </p></h4>
                    <div class="row">
                        <?php
                        if ($msg != '') {
                            ?>
                            <div class="alert alert-warning alert-dismissible fade show"
                                 style="margin-top: 15px" role="alert">
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                <?php
                                echo $msg;
                                ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                    <div class="card">
                        <div class="card-body p-4">

                            <div class="text-center mb-4">
                                <h4 class="text-uppercase mt-0">ورود</h4>
                            </div>

                            <form action="login.php" method="post">
                                <div class="mb-3">
                                    <label for="emailaddress" class="form-label">آدرس ایمیل</label>
                                    <input class="form-control" name="email" type="email" id="emailaddress" required=""
                                           VALUE="" placeholder="لطفا ایمیل خود را وارد کنید">
                                </div>

                                <div class="mb-3">
                                    <label for="password" class="form-label">پسورد</label>
                                    <input class="form-control" name="password" type="password" required=""
                                           id="password"
                                           placeholder="لطفا پسورد خود را وارد کنید">
                                </div>

                                <div class="mb-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="checkbox-signin" checked>
                                        <label class="form-check-label" for="checkbox-signin">مرا به خاطر بسپار</label>
                                    </div>
                                </div>

                                <div class="mb-3 d-grid text-center">
                                    <button class="btn btn-primary" name="submit" type="submit"> ورود</button>
                                </div>
                            </form>

                        </div> <!-- end card-body -->
                    </div>
                    <!-- end card -->

               
                    <!-- end row -->

                </div> <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </div>
    <!-- end page -->

    <!-- Vendor js -->
    <script src="assets/js/vendor.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.min.js"></script>

</body>
</html>