<?php
require_once 'db.php';
require_once 'base.php';
require_once 'class-logs.php';


class User extends Base
{
    private $name;
    private $phone;
    private $st;
    private $codemeli;
private $ban;

    public function __construct()
    {
        $this->table = 'user';
    }

    public function setName($name)
    {

        $this->name = $name;
    }

    public function setPhone($phone)
    {
        $this->phone = $phone;
    }

    public function setSt($st)
    {
        $this->st = $st;
    }
     public function setBan($ban)
    {
        $this->ban = $ban;
    }

    public function setCodeMeli($codemeli)
    {
        $this->codemeli = $codemeli;
    }


    public function insertData()
    {
        $sql = "INSERT INTO $this->table(name,phone,st,codemeli) VALUES(:name,:phone,:st,:codemeli)";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":name", $this->name);
        $stat->bindParam(":phone", $this->phone);
        $stat->bindParam(":st", $this->st);
        $stat->bindParam(":codemeli", $this->codemeli);
        // ob_start();
        // $log = new Logs();
        // $log->setcContent('افزودن مشتری جدید');
        // $log->insertData();
        //  ob_flush();
        $stat->execute();
        return DB::$pdoobj->lastInsertId();
        
    }
  public function existMobile($phone)
    {
        $sql = "SELECT * FROM user WHERE phone=:field ";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":field", $phone);
        $stat->execute();
        $result = $stat->fetch();
        return ($result==false) ? false : $result['id'];

    }
    public function existField($fieldname, $fieldvalue, $id)
    {
        $sql = "SELECT * FROM user WHERE " . $fieldname . "=:field  AND id!=:id  ";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":field", $fieldvalue);
        $stat->bindParam(":id", $id);
        $stat->execute();
        $result = $stat->fetchAll();
        return (count($result) > 0) ? true : false;

    }
    
    
     public function banUser($id)
    {
        $ban=1;
        $sql = "UPDATE $this->table SET ban=:ban  WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":ban", $ban);
        $stat->bindParam(":id", $id);
        return $stat->execute();
    }
 public function UpdateVerifyCode($id,$code,$code_ex)
    {
        $sql = "UPDATE $this->table SET code=:code , code_ex=:code_ex WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":code", $code);
        $stat->bindParam(":code_ex", $code_ex);
        $stat->bindParam(":id", $id);
        return $stat->execute();
    }
     public function UpdateVerifyMobile($id)
    {
        $st =1;
        $sql = "UPDATE $this->table SET mobile_verified=:mobile_verified  WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":mobile_verified", $st);
        $stat->bindParam(":id", $id);
        return $stat->execute();
    }
     public function UpdateVerifyStatus($id,$codemeli)
    {
        $st =1;
        $sql = "UPDATE $this->table SET st=:st,codemeli=:codemeli  WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":codemeli", $codemeli);
        $stat->bindParam(":st", $st);
        $stat->bindParam(":id", $id);
        return $stat->execute();
    }
    public function UpdateData($id)
    {
        $sql = "UPDATE $this->table SET name=:name,phone=:phone,st=:st,ban=:ban,codemeli=:codemeli WHERE id=:id";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":name", $this->name);
        $stat->bindParam(":phone", $this->phone);
        $stat->bindParam(":st", $this->st);
        $stat->bindParam(":ban", $this->ban);
        $stat->bindParam(":codemeli", $this->codemeli);
        $stat->bindParam(":id", $id);
        $log = new Logs();
        $log->setcContent('ویرایش اطلاعات کاربر' . ' ' . $id);
        $log->insertData();
        return $stat->execute();
    }


    
    public function countUsers()
    {
        $sql = "SELECT * FROM $this->table";
        $stat = DB::prepareOwm($sql);
        $stat->execute();
        return count($stat->fetchAll());
    }

    public function countOrder($id)
    {
        $sql = "SELECT * FROM invoice WHERE userid=:userid";
        $stat = DB::prepareOwm($sql);
        $stat->bindParam(":userid", $id);
        $stat->execute();
        return count($stat->fetchAll());
    }

    public function deleteData($id)
    {
        $result = $this->countOrder($id);
   
        if ($result == 0) {
            $sql = "DELETE FROM $this->table WHERE id=:id";
            $stat = DB::prepareOwm($sql);
            $stat->bindParam(':id', $id);
            $status = $stat->execute();
            return $status;
        } else
            throw new Exception("کاربری که سفارش ثبت کرده است امکان حذف ندارد");
    }
    
   public function UserDisbled()
    {
        $sql = "SELECT * FROM $this->table WHERE st=:st ";
        $stat = DB::prepareOwm($sql);
        $st = 0;
        $stat->bindParam(":st", $st);
        $stat->execute();
        return $stat->fetchAll();
    }
    public function countUserDisbled()
    {
        $sql = "SELECT * FROM $this->table WHERE ban=:ban ";
        $stat = DB::prepareOwm($sql);
        $ban = 1;
        $stat->bindParam(":ban", $ban);
        $stat->execute();
        return count($stat->fetchAll());
    }
    public function countUserEnabled()
    {
        $sql = "SELECT * FROM $this->table WHERE st=:st ";
        $stat = DB::prepareOwm($sql);
        $st = 1;
        $stat->bindParam(":st", $st);
        $stat->execute();
        return count($stat->fetchAll());
    }
     public function getAllUserByst($st)
    {
        $sql = "SELECT * FROM $this->table WHERE st=:st ";
         $stat = DB::prepareOwm($sql);
        $stat->bindParam(":st", $st);
        $stat->execute();
        return $stat->fetchAll();
    }
    public function getAllUser($ban)
    {
        $sql = "SELECT * FROM $this->table WHERE ban=:ban ";
         $stat = DB::prepareOwm($sql);
        $stat->bindParam(":ban", $ban);
        $stat->execute();
        return $stat->fetchAll();
    }

}

